package examples.entity.uni.many_to_many.client;

import javax.naming.InitialContext;
import javax.naming.NamingException;

import examples.entity.uni.many_to_many.Course;
import examples.entity.uni.many_to_many.Student;
import examples.entity.uni.many_to_many.interfaces.StudentCourse;


public class StudentCourseClient {
	public static void main(String[] args) {
		try {
			InitialContext ic = new InitialContext();
			StudentCourse sc = (StudentCourse)ic.lookup(StudentCourse.class.getName());
			
			sc.doSomeStuff();
			
			for (Student s : sc.getAllStudents()) {
				System.out.println("Student: "+s.getName());
				for (Course c : s.getCourses()) {
					System.out.println("\tCourse: "+c.getCourseName());
				}
			}
		} 
		catch (NamingException e) {
			e.printStackTrace();
		}
	}
}
